document.addEventListener("DOMContentLoaded", function () {
  const mainBtn = document.getElementById("cb-main-btn");
  const buttons = document.getElementById("cb-contact-buttons");
  let isOpen = false;

  function hideButtons() {
    buttons.classList.add("cb-hidden");
    isOpen = false;
    mainBtn.classList.remove("cb-opened");
  }

  function toggleButtons(e) {
    e.stopPropagation();
    if (isOpen) {
      hideButtons();
    } else {
      buttons.classList.remove("cb-hidden");
      isOpen = true;
      mainBtn.classList.add("cb-opened");
    }
  }

  if (mainBtn && buttons) {
    mainBtn.addEventListener("click", toggleButtons);

    // Hide when clicking anywhere else
    document.addEventListener("click", function (e) {
      if (!mainBtn.contains(e.target) && !buttons.contains(e.target)) {
        hideButtons();
      }
    });

    // Hide on scroll
    window.addEventListener("scroll", function () {
      if (isOpen) {
        hideButtons();
      }
    });

    // Auto animate every 5 seconds
    setInterval(() => {
      mainBtn.classList.add("cb-animate");
      setTimeout(() => {
        mainBtn.classList.remove("cb-animate");
      }, 600);
    }, 5000);
  }
});